﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using LiczbyZespolone;

namespace Mandelbrot
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            Text = "Czekaj...";
            Cursor = Cursors.WaitCursor;

            //cały zbiór
            Complex min = new Complex(-2.2, -1.2); //min,max - zakres badanej plaszczyzny zespolonej
            Complex max = new Complex(1.2, 1.2);

            //fragment
            //Complex min = new Complex(0.2016, 0.541); //min,max - zakres badanej plaszczyzny zespolonej
            //Complex max = new Complex(0.2175, 0.5521);

            Bitmap bufor = new Bitmap(ClientSize.Width, ClientSize.Height);

            for (int x = 0; x < bufor.Width; x++) //x,y - wspolrzedne pikseli
                for (int y = 0; y < bufor.Height; y++)
                {
                    //Mandelbrot
                    Complex c = min + new Complex(x * (max.Real - min.Real) / bufor.Width, y * (max.Imag - min.Imag) / bufor.Height);
                    Complex z = 0;

                    //Julia
                    //Complex c = new Complex(0.25, 0.55);
                    //Complex z = min + new Complex(x * (max.Real - min.Real) / bufor.Width, y * (max.Imag - min.Imag) / bufor.Height);


                    byte indeks = 0;
                    for (; indeks < 255; indeks++)
                    {
                        z = z * z + c;
                        if (z.Norm >= 4) break;
                    }
                    if (indeks == 255) bufor.SetPixel(x, y, Color.Black);
                    else bufor.SetPixel(x, y, Color.FromArgb(255 - indeks, 255 - indeks, 255));
                }
            e.Graphics.DrawImage(bufor, 0, 0);

            Text = "Zbiór Mandelbrota";
            Cursor = Cursors.Arrow;
        }
    }
}
